﻿''' <summary>
''' Form de edição de dados dos Funcionários
''' </summary>
''' <remarks></remarks>
Public Class frmEditarFuncionários
    ''' <summary>
    ''' Rotina executada quando carrega a Form.
    ''' Faz Disable do campo para número de funcionário
    ''' Recontrói Árvore com os funcionários
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    ''' <remarks></remarks>
    Private Sub frmEditarFuncionários_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        Try
            radNome.Checked = True
            txbNúmeroFuncionário.ReadOnly = True
            dtpRescindiuEm.Enabled = chkRescindiuAfirmativo.Checked
            subRebuildArvore()
        Catch ex As Exception
            modLog.subErro(ex)
        End Try
    End Sub
    ''' <summary>
    ''' Verifica se o Funcionário seleccionado não é a Root
    ''' Se não for, lê os valores guardados relativos ao fornecedor seleccionado
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    ''' <remarks></remarks>
    Private Sub tvwFuncionários_AfterSelect(ByVal sender As System.Object, ByVal e As System.Windows.Forms.TreeViewEventArgs) Handles tvwFuncionários.AfterSelect
        Try
            For Each node As TreeNode In tvwFuncionários.Nodes(0).Nodes
                node.BackColor = Color.White
            Next
            If tvwFuncionários.SelectedNode.Tag <> "Funcionários" Then
                subLerFuncionário()
                tvwFuncionários.SelectedNode.BackColor = Color.Aqua
            Else
                subLimpaValores()
            End If
        Catch ex As Exception
            modLog.subErro(ex)
        End Try
    End Sub
    ''' <summary>
    ''' Vamos criar um funcionário novo
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    ''' <remarks></remarks>
    Private Sub btnNovo_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnNovo.Click
        Try
            subLimpaValores()
            subRebuildArvore()
        Catch ex As Exception
            modLog.subErro(ex)
        End Try
    End Sub
    ''' <summary>
    ''' Grava/actualiza os dados do Funcionário
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    ''' <remarks></remarks>
    Private Sub btnGravar_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnGravar.Click
        Try
            If funTestaValores() Then
                Dim x As Integer

                ' Contamos o nº de funcionários
                Dim intNúmeroFuncionário As Integer = 0

                If txbNúmeroFuncionário.Text = "" Then
                    Dim strNúmeroFuncionárioSQL As String = "SELECT NúmeroFuncionário FROM Funcionários"
                    Dim sqlConnNúmeroFuncionários As New SqlConnection(Settings.strSQLConnection)
                    Dim commandFuncionário As New SqlCommand(strNúmeroFuncionárioSQL, sqlConnNúmeroFuncionários)
                    sqlConnNúmeroFuncionários.Open()

                    Dim readerFuncionário As SqlDataReader = commandFuncionário.ExecuteReader()
                    If readerFuncionário.HasRows Then
                        While readerFuncionário.Read()
                            intNúmeroFuncionário += 1
                        End While
                    End If
                    intNúmeroFuncionário += 1
                    txbNúmeroFuncionário.Text = intNúmeroFuncionário.ToString
                    ' Fecha a ligação e limpa as variáveis
                    sqlConnNúmeroFuncionários.Close()
                    sqlConnNúmeroFuncionários = Nothing
                    commandFuncionário = Nothing
                Else
                    intNúmeroFuncionário = Int(txbNúmeroFuncionário.Text)
                End If


                ' Inserimos ou actualizamos os dados dos funcionários na tabela Funcionários
                ' 
                'IF EXISTS (SELECT * FROM Table1 WHERE Column1='SomeValue')
                'UPDATE Table1 SET (...) WHERE Column1='SomeValue'
                'Else
                'INSERT INTO Table1 VALUES (...)
                Dim strFuncionáriosSQL As String = "IF EXISTS "
                strFuncionáriosSQL += " (SELECT NúmeroFuncionário FROM Funcionários WHERE "
                strFuncionáriosSQL += " NúmeroFuncionário ='" & StrConv(txbNúmeroFuncionário.Text.Trim, VbStrConv.ProperCase) & "' "
                strFuncionáriosSQL += ") "
                strFuncionáriosSQL += " UPDATE Funcionários SET "
                strFuncionáriosSQL += " Nome ='" & StrConv(txbNomeFuncionário.Text.Trim, VbStrConv.ProperCase) & "', "
                strFuncionáriosSQL += " Função ='" & StrConv(txbFunçãoFuncionário.Text.Trim, VbStrConv.ProperCase) & "', "
                strFuncionáriosSQL += " NúmeroSegSocial ='" & mtbNúmeroSegSocial.Text.Trim.Replace(" ", "") & "', "
                strFuncionáriosSQL += " NIF ='" & mtbNIF.Text.Trim.Replace(" ", "") & "', "
                strFuncionáriosSQL += " NIB ='" & mtbNIB.Text.Trim.Replace(" ", "") & "', "
                If chkSócioEmpresa.Checked Then
                    strFuncionáriosSQL += " SócioEmpresa ='Sim', "
                Else
                    strFuncionáriosSQL += " SócioEmpresa ='', "
                End If
                strFuncionáriosSQL += " AdmitidoEm ='" & dtpAdmitidoEm.Value.ToString("yyyyMMdd") & "', "
                If chkRescindiuAfirmativo.Checked Then
                    strFuncionáriosSQL += " RescindiuAfirmativo ='Sim', "
                Else
                    strFuncionáriosSQL += " RescindiuAfirmativo ='', "
                End If
                strFuncionáriosSQL += " RescindiuEm ='" & dtpRescindiuEm.Value.ToString("yyyyMMdd") & "' "
                strFuncionáriosSQL += " WHERE NúmeroFuncionário ='" & txbNúmeroFuncionário.Text.Trim & "' "
                strFuncionáriosSQL += " ELSE "
                strFuncionáriosSQL += " INSERT INTO Funcionários VALUES ("
                strFuncionáriosSQL += "'" & intNúmeroFuncionário & "', "
                strFuncionáriosSQL += "'" & StrConv(txbNomeFuncionário.Text.Trim, VbStrConv.ProperCase) & "', "
                strFuncionáriosSQL += "'" & StrConv(txbFunçãoFuncionário.Text.Trim, VbStrConv.ProperCase) & "', "
                If chkSócioEmpresa.Checked Then
                    strFuncionáriosSQL += " 'Sim', "
                Else
                    strFuncionáriosSQL += " '', "
                End If
                strFuncionáriosSQL += "'" & mtbNúmeroSegSocial.Text.Trim.Replace(" ", "") & "', "
                strFuncionáriosSQL += "'" & mtbNIF.Text.Trim.Replace(" ", "") & "', "
                strFuncionáriosSQL += "'" & mtbNIB.Text.Trim.Replace(" ", "") & "', "
                strFuncionáriosSQL += "'" & dtpAdmitidoEm.Value.ToString("yyyyMMdd") & "', "
                If chkRescindiuAfirmativo.Checked Then
                    strFuncionáriosSQL += "'Sim', "
                Else
                    strFuncionáriosSQL += "'', "
                End If
                strFuncionáriosSQL += "'" & dtpRescindiuEm.Value.ToString("yyyyMMdd") & "' "
                strFuncionáriosSQL += ")"

                Dim sqlConnFuncionários As New SqlConnection(Settings.strSQLConnection)
                Dim execFuncionários As New SqlCommand(strFuncionáriosSQL, sqlConnFuncionários)
                sqlConnFuncionários.Open()
                x = execFuncionários.ExecuteNonQuery
                sqlConnFuncionários.Close()
                sqlConnFuncionários = Nothing
                execFuncionários = Nothing
                strFuncionáriosSQL = Nothing

                txbNúmeroFuncionário.Text = intNúmeroFuncionário.ToString
                subRebuildArvore()
            End If
        Catch ex As Exception
            modLog.subErro(ex)
        End Try
    End Sub
    ''' <summary>
    ''' Se o Funcionário rescindíu da empresa (ou foi despedido) permite editar a data da rescisão, caso contrário não permite editar a data
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    ''' <remarks></remarks>
    Private Sub chkRescindiuAfirmativo_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles chkRescindiuAfirmativo.CheckedChanged
        Try
            dtpRescindiuEm.Enabled = chkRescindiuAfirmativo.Checked
        Catch ex As Exception
            modLog.subErro(ex)
        End Try
    End Sub
    ''' <summary>
    ''' O utilizador decidiu actualir a árvore de acordo com a nova ordenação
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    ''' <remarks></remarks>
    Private Sub btnActualizar_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnActualizar.Click
        subRebuildArvore()
    End Sub

    ''' <summary>
    ''' Carrega todos os Funcionários guardados e organiza a árvore alfabéticamente
    ''' </summary>
    ''' <remarks></remarks>
    Private Sub subRebuildArvore()
        Try
            tvwFuncionários.Nodes.Clear()
            Dim strNomeSQL As String = "SELECT * FROM Funcionários ORDER BY "
            If radNúmero.Checked Then
                strNomeSQL += "NúmeroFuncionário"
            ElseIf radNome.Checked Then
                strNomeSQL += "Nome"
            ElseIf radFunção.Checked Then
                strNomeSQL += "Função"
            ElseIf radNúmeroSegSocial.Checked Then
                strNomeSQL += "NúmeroSegSocial"
            ElseIf radNIF.Checked Then
                strNomeSQL += "NIF"
            ElseIf radNIB.Checked Then
                strNomeSQL += "NIB"
            ElseIf radAdmitidoEm.Checked Then
                strNomeSQL += "AdmitidoEm"
            ElseIf radRescindiuEm.Checked Then
                strNomeSQL += "RescindiuEm"
            End If
            strNomeSQL += " ASC"
            Dim dsNome As New DataSet
            Dim sqlConn As New SqlConnection(Settings.strSQLConnection)
            Dim daNome As New SqlDataAdapter(strNomeSQL, Settings.strSQLConnection)

            sqlConn.Open()
            daNome.Fill(dsNome, "Nome")
            sqlConn.Close()

            tvwFuncionários.BeginUpdate()
            Dim nodeRoot As TreeNode
            nodeRoot = New TreeNode
            nodeRoot.Text = "Funcionários"
            nodeRoot.Tag = "Funcionários"
            tvwFuncionários.Nodes.Add(nodeRoot)

            For Each RowFuncionário As DataRow In dsNome.Tables("Nome").Rows
                Dim nodeFuncionário As TreeNode
                nodeFuncionário = New TreeNode
                nodeFuncionário.Text = RowFuncionário("Nome").ToString.Trim
                nodeFuncionário.Tag = RowFuncionário("Nome").ToString.Trim
                If RowFuncionário("RescindiuAfirmativo").ToString = "" Then
                    nodeFuncionário.ForeColor = Color.Gray
                End If
                nodeRoot.Nodes.Add(nodeFuncionário)
            Next
            tvwFuncionários.EndUpdate()
        Catch ex As Exception
            modLog.subErro(ex)
        Finally
            tvwFuncionários.ExpandAll()
        End Try
    End Sub
    ''' <summary>
    ''' Lê todos os dados relativos ao Funcionário seleccionado
    ''' </summary>
    ''' <remarks></remarks>
    Private Sub subLerFuncionário()
        Try
            Dim strFuncionárioSQL As String = "SELECT * FROM Funcionários WHERE Nome='" & tvwFuncionários.SelectedNode.Tag & "'"

            Dim sqlConn As New SqlConnection(Settings.strSQLConnection)
            Dim commandFuncionário As New SqlCommand(strFuncionárioSQL, sqlConn)
            sqlConn.Open()

            ' Executa o comando colocando num SqlDataReader os resultados
            Dim readerFuncionário As SqlDataReader = commandFuncionário.ExecuteReader()
            ' Caso existam rows (linhas)

            If readerFuncionário.HasRows Then
                ' Executa um ciclo nas linhas existentes mostrando o campo “username”
                While readerFuncionário.Read()
                    Dim strNúmeroFuncionário As String = readerFuncionário.Item("NúmeroFuncionário").ToString.Trim()
                    Dim strNome As String = readerFuncionário.Item("Nome").ToString.Trim
                    Dim strFunção As String = readerFuncionário.Item("Função").ToString.Trim
                    Dim strNúmeroSegSocial As String = readerFuncionário.Item("NúmeroSegSocial").ToString.Trim
                    Dim strNIF As String = readerFuncionário.Item("NIF").ToString.Trim
                    Dim strNIB As String = readerFuncionário.Item("NIB").ToString.Trim
                    Dim strSócioEmpresa As String = readerFuncionário.Item("SócioEmpresa").ToString.Trim
                    Dim strRescindiuAfirmatico As String = readerFuncionário.Item("RescindiuAfirmativo").ToString.Trim

                    txbNúmeroFuncionário.Text = strNúmeroFuncionário
                    txbNomeFuncionário.Text = strNome
                    txbFunçãoFuncionário.Text = strFunção
                    mtbNúmeroSegSocial.Text = strNúmeroSegSocial
                    mtbNIF.Text = strNIF
                    mtbNIB.Text = strNIB
                    If strSócioEmpresa = "" Then
                        chkSócioEmpresa.Checked = False
                    Else
                        chkSócioEmpresa.Checked = True
                    End If
                    dtpAdmitidoEm.Value = readerFuncionário.Item("AdmitidoEm")
                    If strRescindiuAfirmatico <> "" Then
                        chkRescindiuAfirmativo.Checked = True
                    Else
                        chkRescindiuAfirmativo.Checked = False
                    End If
                    dtpRescindiuEm.Value = readerFuncionário.Item("RescindiuEm")
                End While
            Else
                subLimpaValores()
            End If

            ' Fecha a ligação e limpa as variáveis
            sqlConn.Close()
            sqlConn = Nothing
            commandFuncionário = Nothing
        Catch ex As Exception
            modLog.subErro(ex)
        End Try
    End Sub
    ''' <summary>
    ''' Rotina que limpa todos os dados das textboxs e passa as datas para hoje.
    ''' </summary>
    ''' <remarks></remarks>
    Private Sub subLimpaValores()
        txbNúmeroFuncionário.Clear()
        txbNomeFuncionário.Clear()
        txbFunçãoFuncionário.Clear()
        mtbNúmeroSegSocial.Clear()
        mtbNIF.Clear()
        mtbNIB.Clear()
        chkSócioEmpresa.Checked = False
        dtpAdmitidoEm.Value = Today
        chkRescindiuAfirmativo.Checked = False
        dtpRescindiuEm.Value = Today
    End Sub
    ''' <summary>
    ''' Valida os valores introduzidos para não dar erro no envio para o SQL
    ''' </summary>
    ''' <returns>Retorna True se todos os dados estiverem correctos</returns>
    ''' <remarks></remarks>
    Private Function funTestaValores() As Boolean
        Try
            If txbNomeFuncionário.Text.Trim = "" Then
                MsgBox("Nome do funcionário não preenchido!")
                Return False
            End If
            If txbNomeFuncionário.Text.Trim.Length > 100 Then
                MsgBox("Nome do funcionário muito comprido!")
                Return False
            End If
            If txbFunçãoFuncionário.Text.Trim = "" Then
                MsgBox("Função do funcionário não preenchido!")
                Return False
            End If
            If txbFunçãoFuncionário.Text.Trim.Length > 50 Then
                MsgBox("Descrição da Função do funcionário muito comprida!")
                Return False
            End If

            ' TODO -> Validar Nº da Segurança Social
            'strUpdateSQL += " NúmeroSegSocial ='" & StrConv(txbNúmeroSegSocial.Text.Trim, VbStrConv.ProperCase) & "',"
            If mtbNúmeroSegSocial.Text.Trim.Length > 50 Then
                MsgBox("Número de Segurança Social muito comprido!")
                Return False
            End If
            If mtbNúmeroSegSocial.Text.Trim = "" Then
                Dim resposta As Integer = MsgBox("O Número de Segurança Social não está preenchido, não será possível imprimir recibos sem este dado!", MsgBoxStyle.YesNo, "Quer continuar?")
                If resposta = vbNo Then Return False
            End If

            If mtbNIF.Text.Trim = "" Then
                Dim resposta As Integer = MsgBox("O Número de Contribuinte não está preenchido, não será possível imprimir recibos sem este dado!", MsgBoxStyle.YesNo, "Quer continuar?")
                If resposta = vbNo Then Return False
            End If
            If mtbNIF.Text.Trim <> "" AndAlso Not modCálculos.funValidarNIF(mtbNIF.Text.Trim.Replace(" ", "")) Then
                MsgBox("Número de Contribuinte errado ou inválido!")
                Return False
            End If

            If mtbNIB.Text.Trim = "" Then
                Dim resposta As Integer = MsgBox("O NIB não está preenchido, não será possível imprimir recibos sem este dado!", MsgBoxStyle.YesNo, "Quer continuar?")
                If resposta = vbNo Then Return False
            End If
            If mtbNIB.Text.Trim <> "" AndAlso Not modCálculos.funValidarNIB(mtbNIB.Text.Trim.Replace(" ", "")) Then
                MsgBox("NIB errado ou inválido!")
                Return False
            End If
            If dtpAdmitidoEm.Value > dtpRescindiuEm.Value Then
                MsgBox("Data de Admissão posterior à Data de Rescisão!")
                Return False
            End If
            Return True
        Catch ex As Exception
            modLog.subErro(ex)
        End Try
    End Function
End Class